
# Age of Mending Game Guide
Guide to the game and its features.

# Overview
The goal of the game is worldbuilding and creative expression. The game attempts to make this as attractive and enjoyable as it can. Therefore there isn't really an end goal to the game other than to build a world you like being in.

But, that doesn't mean there's nothing to do except build. This guide will take you through how the game works, and how to navigate it. Spoilers will be present, particularly further through the guide. After the basic info about how to play it, it's best you come back after you've played the game for a while if you want some mystery.

# Basic How-To

## Movement
You can walk around with the usual keys (check your settings if need be), and **sprinting** is done by walking forward and pressing `aux1`, which by default is set to the `E` key. It's... probably advisable to change it to just about anything else.

When you sneak, your character becomes shorter, allowing you to walk under `2 block` high ceilings.

Some items allow for different movement, and usually those items will have tooltips telling you how to use them.

## Inventory
The inventory is relatively large, and the hotbar is on the bottom, which is different to how Minetest-Game handles things.

## Crafting
Crafting is done completely differently than Minetest does by default. Instead of arranging items into a grid in a specific pattern, the system automatically calculates which recipes you can craft, then displays them in the crafting menu. Clicking on these will craft them. 

Note: since the menu recalculates only once every second or so, it's possible that something is in the menu still even when you can't craft it. When it updates, this might also make the menu jump around, and for a small window of time you can't craft anything, to prevent accidental crafting.

## Cooking
Similar to crafting, there is cooking. Cooking methods turn one thing into another over time. This means you can pipe stuff into these cooker nodes and then extract the result. This is similar to furnaces in most other Minetest games. The difference is that they don't use formspecs. Cookers require a burner to function. Cookers convert items, burners provide the fuel / heat etc to do so.

## Creative
Creative must be enabled per world for most features. This will be made more convenient later in development. In creative, most things don't use up items, and placing and destroying items is free. You can dig all nodes, and craft anything for free, even things that you normally cannot craft. However, this is optimised for development, not creativity. The game itself tries to make creative building as approachable as possible, and so it is not planned to make creative a normal thing people use, as much as a development tool.

## Progression
Progression is intentionally reduced to the bare minimum, with all tools and items being mostly the same in terms of usability; you won't feel that you absolutely must get the best pickaxe, since for 99% of jobs, the sort of thing you can get within half an hour of playing on a new world will not slow you down enough to feel like it's worth it for any reason other than bragging rights, or for specific uses.

# Advanced and Spoilers
These are more advanced, and rather than general information like "this is what this feature does" it goes into specifics; "this feature has X, Y and Z and if you A and B then you can get K and F to happen". If you want to figure stuff out as you go, it's best to avoid this section unless absolutely necessary.

## `Cooking`
Cooking using node timers and callbacks to determine when to change one item into another.

### `Burner nodes list`
These permit or modify how cooker nodes function, providing heat for cooking etc.
- `Fire Pit` (aom_cooking:fire_pit)
    - provides heat to cook food above it
- `Fire` (aom_fire:fire)
    - provides heat to cook food above it
- `Furnace` (aom_cooking:furnace)
    - provides enough heat to melt ores in crucibles above it
- `Lava` (aom_liquids:lava_source)
    - provides enough heat to melt ores in crucibles above it

### `Cooker nodes list`
These are the cooker nodes included in the game as is. These convert one item into its cooked / processed version over time.
- `Anvil` (aom_cooking:anvil)
    - turns ingots into sheets e.g. `iron ingot` --> `iron sheet`, needs no burner
- `Clay Crucible` (aom_cooking:clay_crucible)
    - cooks ores into ingots when above melters / furnaces
- `Oven` (aom_cooking:oven)
    - cooks food, has its own burner to add fuel to
- `Cooking Pot` (aom_cooking:pot)
    - cooks ores into ingots above melters / furnaces, and boils food when placed above fire
- `Cooking Spit` (aom_cooking:spit)
    - cooks meat when placed above fire

## Progression Cheatsheet
- chop a `tree`
- find cobblestone-looking `loose stone` blocks: these are mineable by hand
- normal `stone` can be mined too, just slower
- use those to make `stone tools` in the `inventory`
- look for `coal`
- logs burned in a `campfire` sometimes produce `charcoal` too
- make `torches`
- `clay balls` and `sand` --> `clay crucible` for smelting
- look for ores; iron, copper and tin
- make a `furnace` with cobblestone
- put the `crucible` over the top of the furnace
- give `wood` or `coal` to the `furnace`
- give `ores` to the `crucible`
- yes, you have to do it in this order
- wait for it to `cook`
- `punch` to take items out of `cooking / smelting` equipment
- use `iron bar` and `cobblestone` to make `flint and steel`
- use `flint and steel` to burn `wood logs` to convert them into `charcoal`
- get more `iron bars` and make an `anvil`
- you can also make the `wrench` with `iron bars` which bulk places nodes
- use `anvil` to make `metal sheets`, `copper sheets` can be made into pipes, `iron bars` and `sheets` and `flint and steel` can be made into `flintlock mechanisms`, which with `bronze sheets` and more `iron bars` and `planks` can be made into `flintlock pistols`, which with more `iron` can be made into a `rifle`
- use linen (`flax`) to grow `plant fibre` to turn into `rope` and `canvas` for `airships` and `wings` to glide with
- either explore for plants (`warpberries` and `glowroot` in particular) and ores or go digging
- dig to the `underworld`
- **more spoilers incoming**
- find `cortite` in `lava rocks` (black ore) and `mythril` in `obsidian` (blue ore)
- get a `coral bug` to walk over a `mythril ore` and jump into it, this will allow you to mine it with a `diamond pickaxe`
- make `mythril pickaxe`
- make `cortite sceptre` with `cortite rods` and `glow rock`
- mine `obsidian` and `mythril`
- make a `teleporter` and arrange it in this pattern, where K is `obsidian` with an `obsidian dais` on top, O is `obsidian`, and T is the `teleporter core`. Looking down from above:
```
     K
   O O O
 K O T O K
   O O O
     K
```
- build another one of these, and right click one and then the other. They will now be linked and you can teleport between them freely
- if you leave the server between right clicking one and the other, you will need to start again
- yeah that's about it

